# Функции
Используй ключевое слово `def` для определения новой функции:
`def f(arg1, arg2 = False):
	#код функции`

Для вызова функции можно использовать оператор вызова `()`:
`f(42)`

Чтобы узнать о локальных и глобальных переменных в функциях, см. также [Области видимости](docs/scripting/scopes.md).

## Введение
Тебе уже известно про встроенные функции, такие как `harvest()`.
Ты также можешь определять собственные функции, что позволяет структурировать код модульным образом. По сути, ты можешь дать имя блоку кода, чтобы вызывать его откуда угодно.

## Определения функций
Например, можно определить функцию, которая перемещает дрон несколько раз.

`def move_n_dir(n, dir):
	for i in range(n):
		move(dir)`

Ключевое слово `def` указывает, что это определение функции.
`move_n_dir` — имя, к которому привязывается функция. Это может быть любое допустимое имя переменной. Оно будет использоваться для вызова функции.
`n` и `dir` — параметры. Это переменные, которые содержат значения, передаваемые в функцию (они также называются аргументами). В определение функции можно добавить столько параметров, сколько хочется.
После `:` идет блок кода, который будет выполняться при вызове функции.

С приведенным выше определением следующий код перемещает дрон на `10` клеток в направлении `North` и на `2` клетки в направлении `West`.

`move_n_dir(10, North)
move_n_dir(2, West)`

Когда ты видишь `def function():`, то представляй себе это как присваивание переменной, например:
`function = create_new_function_object()`
Как и при любом присваивании, ты не можешь использовать переменную до того, как ей присвоили значение!
Инструкция `def` должна выполниться до любого вызова функции.
Такой код вызовет ошибку:

`func()
def func():
	pass`

## Возвращаемые значения
Используй ключевое слово `return`, чтобы функция возвращала значение.
Например, следующая функция определяет операцию исключающего ИЛИ. Исключающее ИЛИ возвращает `True`, если одно значение `True`, а другое `False`:

`def xor(a, b):
	return a != b

if xor(True, False):
	do_a_flip()`

[Кортежи](docs/scripting/tuples.md) позволяют возвращать несколько значений.

## Аргументы по умолчанию
Ты также можешь присвоить значения по умолчанию, которые будут использоваться, если не переданы аргументы.

`def f(a = False):
	if a:
		do_a_flip()

f()

f(True)`

Аргумент со значением по умолчанию не может следовать за аргументом, у которого нет значения по умолчанию.

## Продвинутое использование функций
Функции — такие же значения, как и любые другие. Инструкция `def`, по сути, действует как инструкция присваивания: она присваивает функцию тому имени, которое ты дашь.
Это позволяет делать следующее:

`def f():
	def d():
		do_a_flip()
	return d

f()()`

Здесь `f()` вызывает функцию `f`, которая определяет и возвращает новую функцию `d`. Второй вызов `()` выполняет возвращенную функцию и производит сальто.
(Обычно записывать код подобным образом не стоит, потому что трудно понять, что происходит.)

Функции, принимающие другие функции в качестве аргументов, дают большой простор для фантазии:

`def f(g, arg):
	for _ in range(10):
		g(arg)

f(move, North)
f(use_item, Items.Fertilizer)`

Этот код перемещает дрон в направлении `North` 10 раз, а затем 10 раз удобряет землю.